/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.web.common.mongo;

import com.tp_link.eap.web.common.mongo.Repository;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class AbstractRepository<T>
implements Repository<T> {
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected Class<T> entityClass = this.getEntityClass();

    @Override
    public void add(T t) {
        this.mongoTemplate.insert(t);
    }

    @Override
    public T get(String id) {
        return (T)this.getMongoTemplate().findById((Object)id, this.entityClass);
    }

    @Override
    public List<T> findAll() {
        return this.getMongoTemplate().find(new Query(), this.entityClass);
    }

    @Override
    public void findAndModify(String id) {
        this.getMongoTemplate().updateFirst(new Query(Criteria.where((String)"id").is((Object)id)), new Update(), this.entityClass);
    }

    @Override
    public List<T> findByRegex(String field, String regex) {
        Pattern pattern = Pattern.compile(regex, 2);
        Criteria criteria = new Criteria(field).regex(pattern);
        return this.getMongoTemplate().find(new Query(criteria), this.entityClass);
    }

    @Override
    public void removeAll() {
        List<T> list = this.findAll();
        if (list != null) {
            for (T t : list) {
                this.getMongoTemplate().remove(t);
            }
        }
    }

    @Override
    public void removeOne(String id) {
        Query query;
        Criteria criteria = Criteria.where((String)"id").in(new Object[]{id});
        if (criteria != null && (query = new Query(criteria)) != null && this.getMongoTemplate().findOne(query, this.entityClass) != null) {
            this.getMongoTemplate().remove((Object)this.getMongoTemplate().find(query, this.entityClass));
        }
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    protected Class<T> getEntityClass() {
        Type type = this.getClass().getGenericSuperclass();
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return clazz;
    }
}

